
let scene = new THREE.Scene();
let camera = new THREE.PerspectiveCamera(70, 1, 0.1, 1000);
let renderer = new THREE.WebGLRenderer({ antialias:true });
renderer.setSize(450, 450);
document.getElementById("earth-container").appendChild(renderer.domElement);

let geometry = new THREE.SphereGeometry(2, 64, 64);
let texture = new THREE.TextureLoader().load("https://raw.githubusercontent.com/creativetimofficial/public-assets/master/soft-ui-dashboard-pro/assets/img/earth.jpeg");
let material = new THREE.MeshStandardMaterial({ map:texture });

let earth = new THREE.Mesh(geometry, material);
scene.add(earth);

let light = new THREE.PointLight(0xffffff, 2);
light.position.set(5, 5, 5);
scene.add(light);

camera.position.z = 6;

function animate() {
    requestAnimationFrame(animate);
    earth.rotation.y += 0.002;
    renderer.render(scene, camera);
}
animate();
